/*-*- c -*-*******************************************************************
 *
 *  Freescale Confidential Proprietary
 *
 ****************************************************************************/
 /****************************************************************************/
/** Input driver for touch screen, scroll wheel and push buttons on Rainbow EVB revA *
 *  \file      time.h
 *  \author    Davor Bogavac
 *  \date      \$Date: 2010/04/15 
 *
 *  \internal
 *   language  C
 ****************************************************************************/


#ifndef _TIME_H_
#define _TIME_H_

//#include "typedefs.h"

extern void init_time(void);

typedef  struct
{
	uint8_t  	h;		// hours 
	uint8_t  	m;		// minutes 
	uint8_t 	s; 		// seconds
	uint16_t 	ms; 	// mili seconds
	uint32_t	s_total; // seconds since the MCU was started
	uint32_t	ms100_total; //1/10s elapsed since the MCU was powered
} sTime_t;

typedef struct{
	uint32_t 	period;  	// period in ms between each tick
	uint32_t 	period_rl;  	// reload value for period in ms 
	uint32_t 	counter; 	// curent value
	uint32_t	alarm;		// Alarm, when counter = Alarm, the timer is disabled		
	uint8_t 	type;		// type, 0 = disabled, 1 = down counter, 2 upcounter
	void (*callback)();		// optional callback when Alarm is detected
}SWtimer_t;


extern SWtimer_t SWtimer0;

extern sTime_t time;
#endif //_TIME_H_